$(function ($) {

    // Lazy Load
    $('img.lazy').lazyload({
        threshold: 300,  // 300pxの距離まで近づいたら読み込み開始する
        effect: "fadeIn"
    });

    //check inline css
    $.fn.inlineStyle = function (prop) {
        return this.prop("style")[$.camelCase(prop)];
    };


    // ページ内リンクがクリックされた時、ヘッダーの高さ分ずらす
    var headerHeight = 50; //ヘッダの高さ
    $('a[href^=#]:not(.not-pagelink)').click(function(){
        var href= $(this).attr("href");
        var target = $(href == "#" || href == "" ? 'html' : href);
        var position = target.offset().top-headerHeight; //ヘッダの高さ分位置をずらす
        $("html, body").animate({scrollTop:position}, 550, "swing");
        return false;
    });

    //adjust header width
    var flip_width = $('.uk-navbar-flip').width();
    var changeHeaderWidth = function(){
        var $header_title = $('#atwiki-nav a.uk-navbar-brand');
        $header_title.width($(window).width() - flip_width - 46);
    };
    changeHeaderWidth();
    $(window).on('resize', function(){
        changeHeaderWidth();
    });


    //adjust footer searchbox size
    var changeFooterWidth = function(){
        var $search_input = $('#atwiki-footer-search input.uk-search-field');
        var $search_button = $('#atwiki-footer-search input.uk-button');
        $search_input.width($(window).width()-$search_button.width()-90);
    };
    changeFooterWidth();
    $(window).on('resize', function(){
        changeFooterWidth();
    });

    //atwiki search
    $('#atwiki-footer-search form').on('submit', function(){
        if ($('#atwiki-footer-search form [name=searchfrom]:checked').val() == 1) {
            window.location.href = 'https://atwiki.jp/wiki/' + encodeURI($('#atwiki-footer-search input.uk-search-field').val());
            return false;
        }
    });

    //fix table size
    $('table').each(function(i){
        $(this).wrap("<div class=\"uk-overflow-container\">").addClass('uk-table');
    });

    //fixed header & footer link
    var drawer_size = $('.uk-offcanvas-bar:first').outerWidth();
    var header_height = $('header').outerHeight();
    var footer_height = $('footer').outerHeight();
    var prev_scroll_pos = 0;
    var manageScrollRelatedConent = function(){
        var content_height = $('#atwiki-wrapper').outerHeight();
        var TargetPos = header_height;
        var ScrollPos = $(window).scrollTop();

        //fixed header
        if( ScrollPos >= TargetPos) {
            $('#atwiki-wrapper').addClass('fixedHeader');
        } else {
            $('#atwiki-wrapper').removeClass('fixedHeader');
        }
        var ml = $('body').inlineStyle('margin-left');
        if(ml === drawer_size + 'px'){
            if( prev_scroll_pos >= TargetPos) {
                $('#atwiki-wrapper').addClass('fixedHeader');
            }
        } else {
            prev_scroll_pos = ScrollPos;
        }

        //jump link
        var under = $('body').height() - (ScrollPos + $(window).height());
        if(ScrollPos > 200 && 500 < under){
            $('#atwiki-jump-link').fadeIn();
        } else {
            $('#atwiki-jump-link').fadeOut();
        }

    };
    manageScrollRelatedConent();
    $(window).scroll(function () {
        manageScrollRelatedConent();
    });
    $(window).on('resize', function() {
        manageScrollRelatedConent();
    });

    $('#atwiki-jump-link').click(function(){
        $(this).blur();
        $('html,body').animate({scrollTop:0},1);
        return false;
    });

    $('#atwiki-offcanvas').on({
        'show.uk.offcanvas': function () {
            $('#atwiki-close-offcanvas').fadeIn();
        },
        'hide.uk.offcanvas': function(){
            $('#atwiki-close-offcanvas').fadeOut();
        }
    });

});
