(function($){
    var plugin_setform = '';

    $(document).on("click", 'a[class=modal]', function() {
        var pluginlist = $(this).attr('class');
        plugin_setform = $(this).closest('form').find('textarea');
        //console.log(plugin_setform);
        $.ajax({
            type: "POST",
            url : "/_pluginsupport?height=280&width=420",
            data:
                {
                    'list' : pluginlist
                },
            success: function(data) {
                $('#box1').html(data);
            },
            error:function() {
                alert('問題がありました。');
            }

        });
    });

    $(document).on('click', '#box1 a', function() {
        var parentid = $(this).closest('div').attr('id');
        var nameval = $(this).attr('name');
        var content = {};
        var display_id = '#box1';
        if ( $(this).hasClass('back') ) {
            var parts = $(this).attr('name').split(':');
            content[parts[0]] = parts[1];
            $('#plugin_contents').find('input[type=hidden]').each( function(i){
                content[$(this).attr('name')] = $(this).val();
            });
        } else if ( parentid == 'pluginlist' ) {
            content['listname'] = nameval;
        } else {
            content['plugin'] = nameval;
        }
        if ( nameval ) {
            $.ajax({
                type: "POST",
                url : "/_pluginsupport?height=280&width=420",
                data: content,
                success: function(data) {
                    $(display_id).html(data).css('display', 'none');
                    var w = $(display_id).outerWidth();
                    var h = $(display_id).outerHeight();
                    var mt = ($(window).height() - h) / 2 + $(window).scrollTop();
                    //$(display_id).css('top', mt + 'px');
                    $(display_id).fadeIn(500);
                }
            });
            return false;
        } else {
            return true;
        }
    });

    $(document).on("click", 'input[type=submit]', function(){
        var parentid = $(this).closest('div').attr('id');
        var content = {};
        $('#'+parentid + ' input').each( function(i){
            content[$(this).attr('name')] = $(this).val();
        });
        var data = {};
        $.ajax({
            type: "POST",
            url : "/_pluginsupport?height=280&width=420",
            data: content,
            success: function(data) {
                var res = $.parseJSON(data);
                if ( res.success==null && res.error == null && res.confirm == null ) {
                    errMsg( parentid, 'プラグインに不具合があるようです。' );
                    return false;
                }
                if (res.success) {
                    //console.log(plugin_setform);
                    $(plugin_setform).val( $(plugin_setform).val() + res.success );
                    //モーダルウィンドウ削除ロジック
                    //他にいい方法ないか？
                    var mWin = $('#modal-win');
                    var mInner = mWin.find('#modal-win-inner');
                    var contents = mInner.children();
                    mInner.animate({opacity: '0'}, 500, function(){
                        if(contents.attr("id")){
                            $('body').append(contents);
                            contents.hide();
                        }
                        mWin.remove();
                    });
                    $('<div id="modal-bg"></div>').animate({opacity: '0'}, 500);
                    plugin_setform = '';
                    return false;
                } else if (res.confirm) {
                    $('#box1').html(res.confirm);
                    return false;
                } else {
                    errMsg( parentid, res.error );
                    return false;
                }
            }
        });
    });

    function errMsg( parentid, msg ) {
        //console.log(parentid);
        if ( $('#' + parentid + ' span').hasClass('errMsg') ) {
            $('#' + parentid + ' span').html(msg);
        } else {
            $('#' + parentid).prepend( '<span class="errMsg">'+ msg +'</span><br />' );
        }
        return false;
    }


    $(function(){
        simpleModalWindow();
    });

    function simpleModalWindow(){

        var sp = 500;   //アニメーション速度
        var win = $(window);
        var body = $('body');
        var bg = $('<div id="modal-bg"></div>');
        bg.css('opacity', '0');

        //モーダルウィンドウ表示クリックイベント
        //$(document).on('click', '.modal', function(){
        $(document).on('click', ".modal", function(){
            var py = win.scrollTop();
            var wh = win.height();
            var self = $(this);
            var link = self.attr('href');
            var check = link.match(/^#.+/);
            //var mWin = $('<div id="modal-win" style="background-color:#FFFFFF"><div id="modal-win-inner"></div></div>');
            var mWin = $('<div id="modal-win"><div id="modal-win-inner"></div></div>');
            var mInner = mWin.find('#modal-win-inner');
            mInner.css('opacity', '0');
            body.append(mWin);
           mWin.prepend(bg);
            if(!check){
                mInner.append('<img src="' + link + '" alt="" />');
                var img = mWin.find('img');
                img.on('load', function(){
                    view(img);
                });
            }
            else {
                var contents = $(link);
                mInner.append(contents);
                contents.css({display: 'block', zIndex: '101'});
                view(contents);
            }
            function view(a_elm){
                var w = a_elm.outerWidth();
                var h = a_elm.outerHeight();
                var mt = (wh - h) / 2 + py;
                bg.animate({opacity: '.75'}, sp);
                mWin.css('top', mt - 60  + 'px');
                mInner.css({width: w, height: h}).animate({opacity: '1'}, sp);
            }
            return false;
        });

        //モーダルウィンドウ内要素変更クリックイベント
        //$(document).on('click', '.modal-move', function(){
        $(document).on('click', ".modal-move", function(){
            var py = win.scrollTop();
            var wh = win.height();
            var self = $(this);
            var link = self.attr('href');
            var check = link.match(/^#.+/i);
            var mWin = $('#modal-win');
            var mInner = mWin.find('#modal-win-inner');
            if(check){
                mInner.animate({opacity: '0'}, sp, function(){
                    var nowContents = $(this).children();
                    body.append(nowContents);
                    nowContents.hide();
                    var contents = $(link);
                    mInner.append(contents);
                    contents.css({display: 'block', zIndex: '101'});
                    var w = contents.outerWidth();
                    var h = contents.outerHeight();
                    var mt = (wh - h) / 2 + py;
                    bg.animate({opacity: '.75'}, sp);
                    mWin.css('top', mt + 'px');
                    mInner.css({width: w, height: h}).animate({opacity: '1'}, sp);
                });
            }
            return false;
        });

        //モーダルウィンドウクローズクリックイベント
        //$(document).on('click', '#modal-bg, .modal-close', function(){
        $(document).on('click', "#modal-bg, .modal-close", function(){
            var mWin = $('#modal-win');
            var mInner = mWin.find('#modal-win-inner');
            var contents = mInner.children();
            mInner.animate({opacity: '0'}, sp, function(){
                if(contents.attr("id")){
                    body.append(contents);
                    contents.hide();
                }
                mWin.remove();
            });
            bg.animate({opacity: '0'}, sp, function(){bg.remove();});
            return false;
        });

    }

})(atwiki_j$);

